// React moet geïmporteerd worden anders is het niet mogelijk
// de klasse Component uit te breiden.
import React from 'react';

// Container om aan te geven hoe events doorgegeven kunnen worden
// van boven in de componentenboom naar onder.
const InputContainer = (props) => {
    return <input type={"text"} value={props.textValue} onChange={props.changeHandler}/>;
}

export default class Voorbeeld1 extends React.Component {
    style = {
        background: this.props.backgroundColor,
        borderRadius: 10,
        fontFamily: "Oblique, Verdana, serif, sans-serif",
        color: "#F2F2F2",
        padding: "1em",
        margin: "1em 0"
    }

    /**
     * Net zoals functiecomponenten heeft een klasse component ook properties/
     * Deze moeten altijd meegegeven worden via de constructor.
     *
     * @param props
     */
    constructor(props) {
        super(props);
        this.state = {
            textValue: "Initiële waarde"
        }
    }

    /**
     * Dit is de enige verplichte methode in een classe component,
     * geeft verplicht JSX code terug.
     *
     * @return {JSX.Element} De UI die getoond moet worden.
     */
    render = () => {
        return (
            <div style={this.style}>
                <p>Tekst aanpassen is heel eenvoudig!</p>
                <p>De huidige waarde is nu: {this.state.textValue}</p>
                <p>In onderstaand input veld kan je deze waarde aanpassen:</p>
                <div>
                    <input type="text" value={this.state.textValue}
                           onChange={this.handleChange}
                    />
                </div>
                <div>
                    {/* Hier kan onChange niet rechtstreeks gebruikt worden.
                      * Het onChange event zou gekoppeld worden aan de InputContainer
                      * niet aan het formulierelement in deze component.
                      * Een property is de oplossing, maar deze property mag de naam
                      * onChange niet gebruiken omdat dit gereserveerd is voor een event,
                      * daarom wordt de naam changeHandler gebruikt.
                      */}
                    <InputContainer textValue={this.state.textValue}
                                    changeHandler={this.handleChange}/>
                </div>
                <div>
                </div>
            </div>
        )
    }

    handleChange = (e) => {
        // e bevat het change event
        // e.target is het input element dat het event getriggerd heeft.
        // e.target.attributeName kan gebruikt worden om elk attribuut van het input element op te vragen:
        //      - e.target.value --> De nieuwe waarde in het tekst veld
        //      - e.target.type  --> text
        this.setState({textValue: e.target.value});
    }
}
