const Voorbeeld2 = (props) => {
    const style = {
        background: "#2B2B2B",
        borderRadius: 10,
        fontFamily: "Oblique, Verdana, serif, sans-serif",
        color: "#F2F2F2",
        padding: "1em",
        margin: "1em 0"
    }

    // Deze notatie moet zoveel mogelijk vermeiden worden, de map functie is een
    // beter, properder, en korter alternatief.
    // const output = []
    // for (const s of props.subjects) {
    //     output.push(
    //         <li>
    //             {s.name} ({s.sp} studiepunten - Semester {s.semester})
    //         </li>
    //     );
    // }

    return (
        <div style={style}>
            <ul>
                {/* Elk element in een lijst heeft altijd een unieke identifier nodig.
                  * Voor relationele databases is de primary key een goede keuze.
                  * Voor document databases of lijsten die binnen de code opgebouwd worden kan een GUID gebruikt worden.
                  */}
                {props.subjects.map(s => <li key={s.guid}>{s.name} ({s.sp} studiepunten - Semester {s.semester})</li>)}
            </ul>
        </div>
    )
}

export default Voorbeeld2;
