import Container from 'react-bootstrap/Container';
import {Redirect, Route, Switch} from 'react-router-dom';
import Authentication from './authentication/authentication';
import NavBar from './navbar';
import UsernameForm from './authentication/usernameForm';
import ToDoListForm from './todo/toDoListForm';
import ToDoListDetail from './todo/toDoListDetail';
import {Col, Row} from 'react-bootstrap';
import ToDoLists from './todo/toDoLists';
import useSession from '../hooks/useSession';
import useProfile from '../hooks/useProfile';

const App = () => {
    const session = useSession();

    const initialLoginSwitch = <div>
        <Switch>
            <Route path={'/username'} component={UsernameForm}/>
            <Route path={'/'}>
                {/**
                  * Passing the session id is easiest here, since it's already been retrieved, global state offers a
                  * cleaner solution, see the next lecture for an example.
                  **/}
                <Main session={session}/>
            </Route>
        </Switch>
    </div>

    // If the session isn't set, the user isn't allowed to use the site and must first log in.
    return <div>
        {session ? initialLoginSwitch : <Authentication/>}
    </div>;
}

const Main = ({session}) => {
    const {isLoading, username} = useProfile();

    // Don't show anything before the userdata has been retrieved.
    // We can't yet decide what the user must be shown, and directing to /username
    // by default is problematic because, it then becomes difficult to redirect the user back to the home page if the
    // username has been set.
    if (isLoading) {
        return <div></div>
    }

    // If the user is logged in and no username has been set, the user must first do this.
    if (!username && session) {
        return <Redirect to={'/username'}/>;
    }

    return <div>
        <NavBar username={username}/>
        <Container>
            <Row className={"justify-content-center mt-5"}>
                <Col sm={12}>
                    <Switch>
                        <Route exact path={'/lists/:id'} component={ToDoListDetail}/>
                        <Route path={'/lists'} component={ToDoLists}/>
                        <Route path={'/username'} component={UsernameForm}/>
                        <Route path={'/'} component={ToDoListForm}/>
                    </Switch>
                </Col>
            </Row>
        </Container>
    </div>
}

export default App;
