import {Col, Form, Row} from 'react-bootstrap';
import {useRef, useState} from 'react';
import FormSubmitButtonWithLoading from '../utility/formSubmitButtonWithLoading';
import Container from 'react-bootstrap/Container';
import ResponseMessage from '../utility/responseMessage';
import {login} from '../../api/userApi';

const Authentication = () => {
    const [loading, setLoading] = useState(false);
    const [email, setEmail] = useState('');
    const [success, setSuccess] = useState(null);
    const buttonRef = useRef(null);

    const handleLogin = async (event) => {
        event.preventDefault();
        buttonRef.current.blur();
        setLoading(true)
        const success = await login(email);
        setSuccess(success);
        setLoading(false);
    }

    return <Container className={'d-flex flex-column justify-content-center vh-100'}>
        <Row className="justify-content-center">
            <Col xs={12} sm={8} lg={6}>
                <h1>Collaborative To-Do</h1>
            </Col>
        </Row>
        <Row className="justify-content-center">
            <Col xs={12} sm={8} lg={6}>
                <p>Sign in using your email, no password required!</p>
                <Form onSubmit={handleLogin}>
                    <Form.Group className="mb-3" controlId="formBasicEmail">
                        <Form.Label>Email address</Form.Label>
                        <Form.Control type="email" placeholder="Enter email" value={email}
                                      onChange={e => setEmail(e.target.value)}/>
                    </Form.Group>

                    <ResponseMessage success={success}
                        successText={"You've successfully singed up, please check your email for a confirmation link."}
                        failureText={"Something went wrong, please try again."}/>

                    <FormSubmitButtonWithLoading reference={buttonRef} loading={loading} loadingText={'Logging in ...'}
                                                 text={'Log in'}/>

                </Form>

            </Col>
        </Row>
    </Container>
}


export default Authentication;
