import Navbar from 'react-bootstrap/Navbar';
import Container from 'react-bootstrap/Container';
import {LinkContainer} from 'react-router-bootstrap';
import Nav from 'react-bootstrap/Nav';
import {signOut} from '../api/userApi';

const NavBar = ({username}) => {
    const logOutHandler = (event) => {
        event.preventDefault();
        signOut();
    }

    return <Navbar bg="dark" expand="lg" variant="dark">
        <Container fluid>
            <LinkContainer to={'/'}>
                <Navbar.Brand>To-Do</Navbar.Brand>
            </LinkContainer>
            <Navbar.Toggle aria-controls="basic-navbar-nav"/>
            <Navbar.Collapse id="basic-navbar-nav">
                <Nav>
                    <LinkContainer exact to="/">
                        <Nav.Link>Home</Nav.Link>
                    </LinkContainer>
                    <LinkContainer to="/lists">
                        <Nav.Link>Lists</Nav.Link>
                    </LinkContainer>
                </Nav>
            </Navbar.Collapse>
            <Navbar.Collapse className="justify-content-end">
                <Navbar.Text>
                    Welcome {username} <span  style={{color: 'white'}} onClick={logOutHandler}>(Log out)</span>
                </Navbar.Text>
            </Navbar.Collapse>
        </Container>
    </Navbar>;
}

export default NavBar;
