import {Button, ListGroupItem} from 'react-bootstrap';
import {ImCheckmark2, ImCheckmark} from 'react-icons/im';

const TaskItem = ({name, createdBy, changeTaskStatus, completedBy, complete, allowDelete, deleteTaskHandler}) => {
    return <ListGroupItem className={'d-flex flex-column'}>
        <div className={'d-flex flex-row'}>
            <div className="ms-2 me-auto">
                <div className="fw-bold fs-3">
                    {name}
                </div>
                <div className={'text-muted'}>
                    Created by {createdBy.username}
                </div>
            </div>
            <div className={'flex-grow-1'}/>
            <div className="ms-2 me-auto d-flex flex-column align-items-end">
                <div className="fw-bold fs-3" onClick={changeTaskStatus}>
                    {complete ? <ImCheckmark/> : <ImCheckmark2/>}
                </div>
                <div className={'text-muted'}>
                    {complete ? <span>Completed by {completedBy?.username}</span> : <></>}
                    <div/>
                </div>
            </div>
        </div>
        <div>
            {allowDelete ?  <div className={'d-grid mt-2'}>
                <Button variant={'danger'} onClick={deleteTaskHandler}>Delete task</Button>
            </div> : <></>}
        </div>
    </ListGroupItem>
}

export default TaskItem;
