import {Button, Col, Form, ListGroup, Row} from 'react-bootstrap';
import {useEffect, useRef, useState} from 'react';
import TaskItem from './taskItem';
import {createTask, deleteTask, fetchList, updateTask} from '../../api/toDoApi';
import useProfile from '../../hooks/useProfile';

const ToDoListDetail = () => {
    const {userId} = useProfile();
    const [newTaskName, setNewTaskName] = useState('');
    const [toDoList, setToDoList] = useState({});
    const createButton = useRef(null);

    useEffect(() => {
        const abortController = new AbortController();
        const fetchData = async () => {
            // const toDoList = await fetchList(id, abortController);
            // setToDoList(toDoList);
        }
        fetchData();
        return () => abortController.abort();
    }, [])


    const changeTaskStatus = async (name, taskId, newStatus) => {
        const success = await updateTask(toDoList.id, taskId, newStatus);
    }

    const deleteTaskFromList = async (taskId) => {
        const success = await deleteTask(taskId);
    }

    const addTaskToList = async (name) => {
        const success = await createTask(name, toDoList.id);
    }

    const createTaskHandler = async (event) => {
        event.preventDefault();
        createButton.current.blur();
        setNewTaskName('');
        await addTaskToList(newTaskName);
    }

    return <div>
        <Row>
            <Col>
                <h1>{toDoList?.name}</h1>
                <div className={'text-muted'}>
                    Created by {toDoList?.user?.username}
                </div>
                <hr/>
            </Col>
        </Row>

        <Row className={'mb-2 mt-3'}>
            <Form onSubmit={createTaskHandler}>
                <Row>
                    <Col sm={6}>
                        <Form.Group className="mb-3" controlId="formBasicEmail">
                            <Form.Control type="text" value={newTaskName} placeholder="New task"
                                          onChange={evt => setNewTaskName(evt.target.value)}/>
                        </Form.Group>
                    </Col>
                    <Col sm={6}>
                        <div className={'d-grid'}>
                            <Button variant="primary" type="submit" ref={createButton}>
                                Create task
                            </Button>
                        </div>
                    </Col>
                </Row>
            </Form>
        </Row>

        <Row>
            <Col>
                <ListGroup>
                    {toDoList
                        ?.tasks
                        ?.map(t => <TaskItem key={t.id} {...t}
                                             allowDelete={userId === t.createdBy.id || userId === toDoList.user.id}
                                             changeTaskStatus={() => changeTaskStatus(t.name, t.id, !t.complete)}
                                             deleteTaskHandler={() => deleteTaskFromList(t.id)}/>)}
                </ListGroup>
            </Col>
        </Row>
    </div>;
}

export default ToDoListDetail;
