import {useState} from 'react';
import {Button, Form} from 'react-bootstrap';

const ToDoListFormWithSingleState = () => {
    const [list, setList] = useState({name: '', isPrivate: false});

    return <Form>
        <h1>New To-Do List</h1>
        <Form.Group className="mb-3">
            <Form.Label>To-Do list name</Form.Label>
            <Form.Control type="text" required placeholder="List Name"
                          value={list.name}
                          onChange={evt => setList({name: evt.target.value})}/>
        </Form.Group>

        <Form.Group className="mb-3">
            <Form.Check type="checkbox" label="Is private"
                        checked={list.isPrivate} onChange={evt => setList({isPrivate: evt.target.checked})}/>
        </Form.Group>

        <div className="d-grid gap-2">
            <Button variant="primary" type="submit">
                Create To-Do list
            </Button>
        </div>
    </Form>
}

export default ToDoListFormWithSingleState;
