import ToDoListItem from './toDoListItem';
import {useState} from 'react';
import {Button, ListGroup, Tab, Tabs} from 'react-bootstrap';

const ToDoLists = () => {
    const [publicLists, setPublicLists] = useState([]);
    const [userLists, setUserLists] = useState([]);

    return <div>
        <div className={'d-grid mb-4'}>
            {/*<Button variant={'primary'}>*/}
            {/*    Increment dependencies &amp; trigger <i>useEffect</i>*/}
            {/*</Button>*/}
        </div>

        <Tabs justify defaultActiveKey="public" id="uncontrolled-tab-example" className="mb-3">
            <Tab eventKey="public" title="Public lists">
                <h1>Public To-Do lists</h1>
                <ListGroup>
                    {publicLists.map(l => <ToDoListItem key={l.uuid} {...l}/>)}
                </ListGroup>
            </Tab>
            <Tab eventKey="user" title="My lists">
                <h2>My To-Do lists</h2>
                {userLists.map(l => <ToDoListItem key={l.uuid} {...l}/>)}
            </Tab>
        </Tabs>
    </div>
}

export default ToDoLists;
