import {Button, ListGroupItem} from 'react-bootstrap';
import {ImCheckmark2, ImCheckmark} from 'react-icons/im';
import PropTypes from 'prop-types';

/**
 * Properties can either be added as an object, or via explicit reference. Explicit reference is clearer because every
 * property must be listed explicitly. However, the component definition  could become excessively long.
 */
const TaskItem = ({name, createdBy, changeTaskStatus, completedBy, complete, allowDelete, deleteTaskHandler}) => {
    return <ListGroupItem className={'d-flex flex-column'}>
        <div className={'d-flex flex-row'}>
            <div className="ms-2 me-auto">
                <div className="fw-bold fs-3">
                    {name}
                </div>
                <div className={'text-muted'}>
                    Created by {createdBy.username}
                </div>
            </div>
            <div className={'flex-grow-1'}/>
            <div className="ms-2 me-auto d-flex flex-column align-items-end">
                <div className="fw-bold fs-3" onClick={changeTaskStatus}>
                    {complete ? <ImCheckmark/> : <ImCheckmark2/>}
                </div>
                <div className={'text-muted'}>
                    {complete ? <span>Completed by {completedBy?.username}</span> : <></>}
                    <div/>
                </div>
            </div>
        </div>
        <div>
            {allowDelete ?  <div className={'d-grid mt-2'}>
                <Button variant={'danger'} onClick={deleteTaskHandler}>Delete task</Button>
            </div> : <></>}
        </div>
    </ListGroupItem>
}

/**
 * The prop-types library can be used to specify which properties are required for a given component.
 */
TaskItem.propTypes = {
    name: PropTypes.string.isRequired,
    createdBy: PropTypes.shape({
        username: PropTypes.string.isRequired
    }),
    completedBy: PropTypes.shape({
        username: PropTypes.string
    }),
    complete: PropTypes.bool.isRequired,
    allowDelete: PropTypes.bool.isRequired,
    deleteTaskHandler: PropTypes.func.isRequired,
    changeTaskStatus: PropTypes.func.isRequired,
    // Since the following property will never be passed to the component it can be uncommented to
    // produce an error message in the console an see how the prop-types library works.
    // thisPropertyWillGenerateAWarning: PropTypes.string.isRequired
}

/**
 * The prop-types library can also be used to specify default values for certain properties.
 */
TaskItem.defaultProps = {
    allowDelete: false
}

export default TaskItem;
