import {useState} from 'react';
import {Button, Form} from 'react-bootstrap';

const ToDoListFormWithSingleState = () => {
    /**
     * In a class component we would use a single state object, this would then be updated through a
     * setState call. However, the useState hook REPLACES the state, it does not merge. Therefore, it becomes
     * a bad idea to store state in a single object. As demonstrated on lines 19 and 24, this requires that we
     * reset every attribute in the object on every update.
     */
    const [list, setList] = useState({name: '', isPrivate: false});

    return <Form>
        <h1>New To-Do List</h1>
        <Form.Group className="mb-3">
            <Form.Label>To-Do list name</Form.Label>
            <Form.Control type="text" required placeholder="List Name"
                          value={list.name}
                          onChange={evt => setList({isPrivate: list.isPrivate, name: evt.target.value})}/>
        </Form.Group>

        <Form.Group className="mb-3">
            <Form.Check type="checkbox" label="Is private"
                        checked={list.isPrivate} onChange={evt => setList({...list, isPrivate: evt.target.checked})}/>
        </Form.Group>

        <div className="d-grid gap-2">
            <Button variant="primary" type="submit">
                Create To-Do list
            </Button>
        </div>
    </Form>
}

export default ToDoListFormWithSingleState;
