import {ListGroupItem} from 'react-bootstrap';
import {useHistory, useRouteMatch} from 'react-router-dom';

const ToDoListItem = (props) => {
    const match = useRouteMatch();
    const history = useHistory();

    const navigateToDetail = () => {
        history.push(`${match.path}/${props.uuid}`);
    }

    return <ListGroupItem className={'d-flex justify-content-between align-items-start'}
                          action onClick={navigateToDetail}>
        <div className="ms-2 me-auto">
            <div className="fw-bold fs-3">
                {props.name}
            </div>
            <div className={'text-muted'}>
                Created by {props.username} {props.user.username}
            </div>
        </div>
    </ListGroupItem>
}

export default ToDoListItem;
