import {useEffect, useState} from 'react';
import useSession from './useSession';
import {getProfile, upsertProfile} from '../api/userApi';

const useProfile = () => {
    const session = useSession();
    const [username, setUsername] = useState(null);
    const [userId, setUserId] = useState(null);
    const [isLoading, setIsLoading] = useState(true);

    useEffect(() => {
        setIsLoading(true);
        const fetchProfile = async () => {
            const [id, data] = await getProfile();
            setUsername(data ? data.username : null);
            setUserId(id ? id : null);
            setIsLoading(false);
        }
        fetchProfile();
    }, [session]);


    const upsert = async (username) => {
        if (!userId) return;
        const success = await upsertProfile(username);
        if (success) setUsername(username);
        return success;
    }

    return {isLoading, username, userId, upsert};
}

export default useProfile;
