import React, {useState} from 'react';
import useProfile from './hooks/useProfile';
import Authentication from './authentication/authentication';
import UsernameForm from './authentication/usernameForm';
import Container from 'react-bootstrap/Container';
import NavBar from './navbar/navbar';
import Filesystem from './filesystem/filesystem';
import {languages} from './data/i18n';
import {Route, Switch} from "react-router-dom";
import NoteDetail from './notes/noteDetail';
import NotesPage from './notes/notesPage';

export const UserContext = React.createContext({session: null, username: null});
export const LanguageContext = React.createContext({selectedLanguage: undefined, i18nChangeHandler: () => undefined});

const chosenLanguage = JSON.parse(localStorage.selectedLanguage || null) || languages[0]

export const App = () => {
    const {session, username} = useProfile();
    const [selectedLanguage, setSelectedLanguage] = useState(chosenLanguage);

    if (!session) {
        return <Authentication/>;
    }

    if (session && !username) {
        return <UsernameForm/>
    }

    const i18nChangeHandler = (newSelectedLanguage) => {
        console.log("Changing to", newSelectedLanguage);
        setSelectedLanguage(newSelectedLanguage);
        localStorage.selectedLanguage = JSON.stringify(newSelectedLanguage);
    }

    return <LanguageContext.Provider value={{selectedLanguage: selectedLanguage, i18nChangeHandler}}>
        <UserContext.Provider value={{session, username}}>
            <Main/>
        </UserContext.Provider>
    </LanguageContext.Provider>;
}

const Main = () => {
    return <div className={"h-100 d-flex flex-column"}>
        <NavBar/>
        <Container className={"flex-grow-1"}>
            <Switch>
                <Route path="/filesystem" component={Filesystem}/>
                <Route exact path="/notes/:id" component={NoteDetail}/>
                <Route path="/notes" component={NotesPage}/>
            </Switch>
        </Container>
    </div>
}
