import {useRef, useState} from 'react';
import {Col, Form, Row} from 'react-bootstrap';
import FormSubmitButtonWithLoading from '../utility/formSubmitButtonWithLoading';
import ResponseMessage from '../utility/responseMessage';
import Container from 'react-bootstrap/Container';
import {upsertProfile} from '../api/userApi';
import useIsMounted from '../hooks/isMounted';

const UsernameForm = () => {
    const [newUsername, setNewUsername] = useState('');
    const [successfullyUpdated, setSuccessfullyUpdated] = useState(null);
    const [loading, setLoading] = useState(false);
    const submitRef = useRef(null);
    const isMounted = useIsMounted();

    const submitForm = async (e) => {
        e.preventDefault();
        setSuccessfullyUpdated(null);
        submitRef.current.blur();
        setLoading(true);
        const success = await upsertProfile(newUsername);
        if (isMounted) setSuccessfullyUpdated(success);
        if (isMounted) setLoading(false);
    }

    const successMessage = <span>You've successfully updated your username. You can now use the site!&nbsp;
        You'll be redirected automatically.</span>;

    const failureMessage = <span>We were unable to update your username, please try again.</span>;

    return <Container className={'d-flex flex-column justify-content-center vh-100'}>
        <Row className="justify-content-center">
            <Col xs={12} sm={8} lg={6}>
                <Form onSubmit={submitForm} className={'mt-5'}>
                    <h1>Update username</h1>

                    <p>A username is required to use this site, this is the name by which other users will
                        be able to identify you.
                    </p>

                    <Form.Group className="mb-3">
                        <Form.Label>Choose your username</Form.Label>
                        <Form.Control type="text" required
                                      placeholder="Username"
                                      value={newUsername}
                                      onChange={evt => setNewUsername(evt.target.value)}/>
                    </Form.Group>

                    <ResponseMessage success={successfullyUpdated} successText={successMessage}
                                     failureText={failureMessage}/>

                    <FormSubmitButtonWithLoading reference={submitRef} text={'Update username'}
                                                 loadingText={'Updating username...'} loading={loading}/>
                </Form>
            </Col>
        </Row>

    </Container>
}

export default UsernameForm;
