import {Card} from "react-bootstrap";
import PropTypes from 'prop-types';
import {useState} from 'react';

const File = ({name, clickHandler, useNewFileIcon}) => {
    const iconStyle = {
        fontSize: "5em",
    }

    const nameStyle = {
        fontSize: "1.3em",
    }

    const cardStyle = {
        width: '10em',
        textAlign: 'center',
        margin: '1em'
    }

    const cardStyleHover = {
        width: '10em',
        textAlign: 'center',
        margin: '1em',
        backgroundColor: '#f6f6f6',
        cursor: 'pointer'
    }

    const [activeStyle, setActiveStyle] = useState(cardStyle)
    const icon = useNewFileIcon ? "bi bi-file-earmark-plus" : "bi bi-file-earmark-font"

    return <Card style={activeStyle}
                 onClick={clickHandler}
                 onMouseEnter={() => setActiveStyle(cardStyleHover)}
                 onMouseLeave={() => setActiveStyle(cardStyle)}>
        <Card.Title>
            <i className={icon} style={iconStyle}/><br/>
            <span style={nameStyle}>{name}</span>
        </Card.Title>
    </Card>
}

File.propTypes = {
    name: PropTypes.string.isRequired,
    clickHandler: PropTypes.func.isRequired,
    useNewFileIcon: PropTypes.bool.isRequired,
}

File.defaultProps = {
    clickHandler: () => console.log('No custom click handler has been specified.'),
    name: 'New Note',
    useNewFileIcon: true
}


export default File;