import {Row} from 'react-bootstrap';
import Folder from './folder';
import {useRecoilRefresher_UNSTABLE, useRecoilValue, useSetRecoilState} from 'recoil';
import {
    currentDirectoryContent,
    currentDirectoryId,
    currentDirectoryParent,
    filesystem
} from '../recoilState/filesystem';
import File from './file';
import {useState} from 'react';
import NewNote from './newNote';
import React from 'react';
import NoteList from './noteList';
import LoadingFile from './loadingFile';
import {notesInCurrentDirectory} from '../recoilState/notes';

const Filesystem = () => {
    /**
     * Uncomment to retrieve all folders, without taking
     * the hierarchical file structure into account.
     * The useRecoilValue hook returns the VALUE of the state,
     * it does not return a setter.
     **/
    // const folders = useRecoilValue(filesystem);

    /**
     * The useRecoilValue hooks allows us to read the data
     * contained in an atom or selector, there is no difference
     * between the two. At least as far as useRecoilValue is concerned.
     */
    const folders = useRecoilValue(currentDirectoryContent);

    /**
     * The useSetRecoilState hook can be used to retrieve a setter for
     * some global state. However, this hook does not return the value of the
     * state.
     */
    const setCurrentDirectoryId = useSetRecoilState(currentDirectoryId);
    const parentId = useRecoilValue(currentDirectoryParent);
    const [showNewNote, setShowNewNote] = useState(false);
    const refreshDataForCurrentDirectory = useRecoilRefresher_UNSTABLE(notesInCurrentDirectory);

    return <Row>
        {parentId !== undefined ?
            <Folder name=".." clickHandler={() => setCurrentDirectoryId(parentId)}/> :
            <></>
        }
        {folders.map(f => <Folder key={f.id} name={f.name} clickHandler={() => setCurrentDirectoryId(f.id)}/>)}

        <React.Suspense fallback={<LoadingFile/>}>
            <NoteList/>
        </React.Suspense>
        <File clickHandler={() => setShowNewNote(true)}/>

        <NewNote show={showNewNote}
                 closeHandlerHook={() => setShowNewNote(false)}
                 createHandlerHook={() => {refreshDataForCurrentDirectory()}}/>
    </Row>
}

export default Filesystem;
