import {useRecoilValue} from 'recoil';
import {notesInCurrentDirectory} from '../recoilState/notes';
import File from './file';
import {useHistory} from 'react-router-dom';

const NoteList = () => {
    const history = useHistory();
    const notes = useRecoilValue(notesInCurrentDirectory);
    return <>
        {notes.map(n =>
            <File useNewFileIcon={false} key={n.id} name={n.title}
                  clickHandler={() => history.push(`/notes/${n.id}`)}/>)}
    </>
}

export default NoteList;