import React from 'react';
import NoteEditor from './noteEditor';
import {RingLoader} from 'react-spinners';

const NoteDetail = () => {
    return <React.Suspense fallback={<Loading/>}>
        <NoteEditor/>
    </React.Suspense>
}

const Loading = () => {
    const spinnerStyle = {
        position: 'fixed',
        zIndex: 99,
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        margin: 'auto',
        width: '10em',
        height: '10em',
    }
    return <div style={spinnerStyle}>
        <RingLoader color={'#313335'} loading={true} size={100} />
    </div>
}

export default NoteDetail;