import {Button, Col, Form, Row} from 'react-bootstrap';
import ReactMarkdown from 'react-markdown';
import {useParams} from 'react-router-dom';
import {useRef} from 'react';
import {useRecoilState} from 'recoil';
import {noteById} from '../recoilState/notes';
import {upsertNote} from '../api/notesApi';

const NoteEditor = () => {
    const {id} = useParams();
    const [note, setNote] = useRecoilState(noteById(id));
    const hasUnsavedChanges = useRef(false);

    const updateNote = (evt) => {
        setNote({...note, content: evt.target.value});
        hasUnsavedChanges.current = true;
    }

    const saveNote = (evt) => {
        upsertNote(note.title, note.folder_id, note.id, note.content);
        evt.target.blur();
    }

    return  <Row className={"h-100 flex-column mt-1"}>
        <Row className={"flex-grow-1"}>
            <Col sm={12} md={6} >
                <Form.Control as="textarea" className={'h-100'}
                              value={note.content}
                              onChange={updateNote}/>
            </Col>
            <Col sm={12} md={6} className={"flex-grow-1"}>
                <ReactMarkdown>
                    {note.content}
                </ReactMarkdown>
            </Col>
        </Row>
        <Col sm={12} className={'p-1 m-1 d-grid bg-light text-center'}>
            <Button disabled={!hasUnsavedChanges} onClick={saveNote}>Save changes</Button>
        </Col>
    </Row>
}

export default NoteEditor;