import {atom, selector} from 'recoil';
import folders from '../data/folders';

export const filesystem = atom({
    key: 'filesystem',
    default: folders
});

export const currentDirectoryId = atom({
    key: 'currentDirectoryId',
    default: null // Start at the root level of the file structure.
})

export const currentDirectoryContent = selector({
    key: 'currentDirectoryContent',
    get: ({get}) => {
        const parentId = get(currentDirectoryId);
        return get(filesystem)
            .filter(d => d.parent === parentId)
            .sort((a, b) => a.name < b.name ? -1 : 1);
    }
})

export const currentDirectoryParent = selector({
    key: 'currentDirectoryParent',
    get: ({get}) => {
        const currentId = get(currentDirectoryId);
        if (!currentId) {
            return undefined;
        }
        return get(filesystem).find(f => f.id === currentId).parent;
    }
})