import {atomFamily, selector, selectorFamily} from 'recoil';
import {getNote, getNotesForDirectory, getNotesForUser} from '../api/notesApi';
import {currentDirectoryId} from './filesystem';

export const editedNote = atomFamily({
    key: 'editedNote',
    default: undefined
})

export const noteById = selectorFamily({
    key: 'noteById',
    get: id => ({get}) => {
        return get(editedNote(id)) ||  getNote(id)
    },
    set: id => ({set}, newValue) => {
        set(editedNote(id), newValue);
    }
})


export const notesInCurrentDirectory = selector({
    key: 'notesInCurrentDirectory',
    get: async ({get}) => {
        return  await getNotesForDirectory(get(currentDirectoryId));
    }
})

export const notesForCurrentUser = selector({
    key: 'notesForCurrentUser',
    get: async ({get}) => {
        return await getNotesForUser();
    }
})

