import useProfile from './hooks/useProfile';
import Authentication from './authentication/authentication';
import UsernameForm from './authentication/usernameForm';
import Container from 'react-bootstrap/Container';
import NavBar from './navbar/navbar';
import Filesystem from './filesystem/filesystem';
import {Route, Switch} from "react-router-dom";
import NoteDetail from './notes/noteDetail';


export const App = () => {
    const {session, username} = useProfile();

    if (!session) {
        return <Authentication/>;
    }

    if (session && !username) {
        return <UsernameForm/>
    }

    return <Main/>;
}

const Main = () => {
    return <div className={"h-100 d-flex flex-column"}>
        <NavBar/>
        <Container className={"flex-grow-1"}>
            <Switch>
                <Route path="/filesystem" component={Filesystem}/>
                <Route exact path="/notes/:id" component={NoteDetail}/>
                {/*<Route path="/notes" component={NotesPage}/>*/}
            </Switch>
        </Container>
    </div>
}
