import {Card} from "react-bootstrap";
import PropTypes from 'prop-types';
import {useState} from 'react';

const Folder = ({name, clickHandler}) => {
    const iconStyle = {
        fontSize: "5em",
    }

    const nameStyle = {
        fontSize: "1.3em",
    }

    const cardStyle = {
        width: '10em',
        textAlign: 'center',
        margin: '1em'
    }

    const cardStyleHover = {
        width: '10em',
        textAlign: 'center',
        margin: '1em',
        backgroundColor: '#f6f6f6',
        cursor: 'pointer'
    }

    const [activeStyle, setActiveStyle] = useState(cardStyle)

    return <Card style={activeStyle}
                 onClick={clickHandler}
                 onMouseEnter={() => setActiveStyle(cardStyleHover)}
                 onMouseLeave={() => setActiveStyle(cardStyle)}>
        <Card.Title>
            <i className="bi bi-folder" style={iconStyle}/><br/>
            <span style={nameStyle}>{name}</span>
        </Card.Title>
    </Card>
}

Folder.propTypes = {
    name: PropTypes.string.isRequired,
    clickHandler: PropTypes.func.isRequired
}

Folder.defaultProps = {
    clickHandler: () => console.log('Clicking a folder is not implemented yet.')
}


export default Folder;