import Button from 'react-bootstrap/Button';
import Modal from 'react-bootstrap/Modal';
import Form from 'react-bootstrap/Form';
import PropTypes from 'prop-types';
import {useState} from 'react';
import {upsertNote} from '../api/notesApi';
import {useRecoilValue} from 'recoil';
import {currentDirectoryId} from '../recoilState/filesystem';

const NewNote = ({closeHandlerHook, show, createHandlerHook}) => {
    const [title, setTitle] = useState('');
    const currentDir = useRecoilValue(currentDirectoryId);

    const createHandler = async () => {
        await upsertNote(title, currentDir);
        createHandlerHook();
        closeHandler();
    }

    const closeHandler = () => {
        setTitle('');
        closeHandlerHook();
    }

    return <Modal show={show} centered onHide={closeHandler}>
        <Modal.Header closeButton>
            <Modal.Title>New note</Modal.Title>
        </Modal.Header>

        <Modal.Body>
            <p>Please enter a title for the new markdown note.</p>
            <Form.Group className="mb-3">
                <Form.Control type="email" placeholder="The title of the new note"
                              value={title}
                              onChange={(evt) => setTitle(evt.target.value)}/>
            </Form.Group>
        </Modal.Body>

        <Modal.Footer>
            <Button variant="secondary" onClick={closeHandler}>Cancel</Button>
            <Button variant="primary" onClick={createHandler}>Create Note</Button>
        </Modal.Footer>
    </Modal>
}

NewNote.propTypes = {
    closeHandlerHook: PropTypes.func,
    show: PropTypes.bool.isRequired,
    createHandlerHook: PropTypes.func
}

NewNote.defaultProps = {
    closeHandlerHook: () => console.log('No custom hook for the close handler has been defined.'),
    createHandlerHook: () => console.log('No custom hook for the create handler has been defined.'),
    show: false
}

export default NewNote;