import {useEffect, useRef, useState} from 'react';
import useSession from './useSession';
import {getProfileRealTime} from '../api/userApi';
import useIsMounted from './isMounted';

const useProfile = () => {
    const session = useSession();
    const [username, setUsername] = useState(null);
    const [userId, setUserId] = useState(null);
    const [isLoading, setIsLoading] = useState(true);
    const isMounted = useIsMounted();
    const subscription = useRef(undefined);

    useEffect(() => {
        if (!session) {
            setUsername(null);
            setUserId(null);
            return;
        }

        const profileChangeHandler = ([id, data]) => {
            if (isMounted) {
                setUsername(data?.username);
            }
            if (id && isMounted) setUserId(id ? id : null);
            setIsLoading(false);
        };

        getProfileRealTime(profileChangeHandler).then(sub => subscription.current = sub);

        return () => {
            if (subscription.current) {
                subscription.current.unsubscribe();
                subscription.current = undefined;
            }
        }
    }, [session, isMounted]);

    return {isLoading, session, username, userId};
}

export default useProfile;
