import {useEffect, useState} from 'react';
import supabaseClient from '../api/supabaseClient';

const useSession = () => {
    const [session, setSession] = useState(null);

    useEffect(() => {
        setSession(supabaseClient.auth.session())

        supabaseClient.auth.onAuthStateChange((_event, session) => {
            console.log('Session changed');
            setSession(session)
        })
    }, [])
    return session;
}

export default useSession;
