import Navbar from 'react-bootstrap/Navbar';
import Container from 'react-bootstrap/Container';
import {LinkContainer} from 'react-router-bootstrap';
import Nav from 'react-bootstrap/Nav';
import {signOut} from '../api/userApi';

const NavBar = () => {


    const logOutHandler = (event) => {
        event.preventDefault();
        signOut();
    }

    return <Navbar bg="dark" expand="lg" variant="dark">
        <Container fluid>
            <LinkContainer to={'/'}>
                <Navbar.Brand>Markdown Notes</Navbar.Brand>
            </LinkContainer>
            <Navbar.Toggle aria-controls="basic-navbar-nav"/>
            <Navbar.Collapse id="basic-navbar-nav">
                <Nav>
                    <LinkContainer exact to="/filesystem">
                        <Nav.Link>Folders</Nav.Link>
                    </LinkContainer>
                    <LinkContainer to="/notes">
                        <Nav.Link>My Notes</Nav.Link>
                    </LinkContainer>
                </Nav>
            </Navbar.Collapse>
            <Navbar.Collapse className="justify-content-end">
                {/*<NavDropdown title={`${selectedLanguage.flag} ${selectedLanguage.name}`} id="basic-nav-dropdown">*/}
                {/*    {languages*/}
                {/*        .map(l => <NavDropdown.Item key={l.i18n}>*/}
                {/*            {l.flag} {l.name}*/}
                {/*        </NavDropdown.Item>)*/}
                {/*    }*/}
                {/*</NavDropdown>*/}
                {/*<Navbar.Text>*/}
                {/*    Welcome {username} <span  style={{color: 'white'}} onClick={logOutHandler}>(Log out)</span>*/}
                {/*</Navbar.Text>*/}
            </Navbar.Collapse>
        </Container>
    </Navbar>;
}

export default NavBar;
