import {useRecoilRefresher_UNSTABLE, useRecoilValue} from 'recoil';
import {notesForCurrentUser, notesInCurrentDirectory} from '../recoilState/notes';
import {Table} from 'react-bootstrap';
import {useHistory, useRouteMatch} from 'react-router-dom';
import React from 'react';
import {deleteNote} from '../api/notesApi';

const NoteRow = ({id, title}) => {
    const history = useHistory();
    const match = useRouteMatch();
    const refresh = useRecoilRefresher_UNSTABLE(notesForCurrentUser);
    const refresh2 = useRecoilRefresher_UNSTABLE(notesInCurrentDirectory);

    const _deleteNote = async () => {
        await deleteNote(id);
        refresh();
        refresh2();
    }

    const editNote = () => {
        history.push(`${match.path}/${id}`)
    }

    return <tr>
        <td>{title}</td>
        <td onClick={editNote}><i className="bi bi-pencil-square"/></td>
        <td onClick={_deleteNote}><i className="bi bi-trash2-fill"/></td>
    </tr>
}

const NotesList = () => {
    const notes = useRecoilValue(notesForCurrentUser);

    return <Table striped bordered hover className={"mt-2"}>
        <thead>
        <tr>
            <th>Title</th>
            <th>Edit</th>
            <th>Delete</th>
        </tr>
        </thead>

        <tbody>
        {notes.map(n => <NoteRow key={n.id} {...n}/>)}
        </tbody>
    </Table>
}

const NotesPage = () => {
    return <React.Suspense fallback={<div>...loading</div>}>
        <NotesList/>
    </React.Suspense>
}

export default NotesPage;