import {Button, ProgressBar} from 'react-bootstrap';

const FormSubmitButtonWithLoading = ({loading, text, loadingText, reference}) => {
    const style = {
        height: '1.5rem' // Ensure that the button has the same height when showing the loading bar.
    }

    return <div className={"d-grid"}>
        <Button variant="primary" type={"submit"} ref={reference} disabled={loading}>
            {loading ? <ProgressBar style={style} striped variant="info" now={100} animated label={loadingText}/> : text}
        </Button>
    </div>
}

export default FormSubmitButtonWithLoading;
